/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.extendedexchange.menu;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import dev.ftb.extendedexchange.menu.AbstractTableMenu;
import dev.ftb.extendedexchange.menu.ModMenuTypes;
import dev.ftb.extendedexchange.util.EXUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.config.ProjectEConfig;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class ArcaneTabletMenu
extends AbstractTableMenu {
    private static final int[] ROTATION_SLOTS = new int[]{0, 1, 2, 5, 8, 7, 6, 3};
    private final CraftingContainer craftMatrix = new ArcaneTabletCraftingContainer(this, 3, 3, (IItemHandlerModifiable)this.getProvider().getInputAndLocks());
    private final ResultContainer craftResult = new ResultContainer();

    public ArcaneTabletMenu(int windowId, Inventory invPlayer) {
        super((MenuType)ModMenuTypes.ARCANE_TABLET.get(), windowId, invPlayer, null);
        this.m_38897_((Slot)new ArcaneTabletResultSlot(invPlayer.f_35978_, this.craftMatrix, (Container)this.craftResult, 0, -23, 75));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                this.m_38897_(new Slot((Container)this.craftMatrix, x + y * 3, -59 + x * 18, 17 + y * 18));
            }
        }
        this.addPlayerSlots(invPlayer, 8, 135);
        ArcaneTabletMenu.slotChangedCraftingGrid(this, invPlayer.f_35978_.f_19853_, invPlayer.f_35978_, this.craftMatrix, this.craftResult);
    }

    public ArcaneTabletMenu(int windowId, Inventory playerInv, FriendlyByteBuf buf) {
        this(windowId, playerInv);
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        switch (tag) {
            case "clear": {
                this.clearCraftingMatrix();
                return;
            }
            case "rotate": {
                this.rotateCraftingMatrix(!shiftHeld);
                return;
            }
            case "balance": {
                if (shiftHeld) {
                    this.spreadCraftingMatrix();
                } else {
                    this.balanceCraftingMatrix();
                }
                return;
            }
        }
        super.handleGUIButtonPress(tag, shiftHeld, player);
    }

    static void slotChangedCraftingGrid(AbstractContainerMenu menu, Level level, Player player, CraftingContainer container, ResultContainer result) {
        CraftingRecipe craftingRecipe;
        if (level.f_46443_) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ItemStack itemStack = ItemStack.f_41583_;
        Optional optional = level.m_142572_().m_129894_().m_44015_(RecipeType.f_44107_, (Container)container, level);
        if (optional.isPresent() && result.m_40135_(level, serverPlayer, (Recipe)(craftingRecipe = (CraftingRecipe)optional.get()))) {
            itemStack = craftingRecipe.m_5874_((Container)container);
        }
        result.m_6836_(0, itemStack);
        menu.m_150404_(0, itemStack);
        serverPlayer.f_8906_.m_141995_((Packet)new ClientboundContainerSetSlotPacket(menu.f_38840_, menu.m_182425_(), 0, itemStack));
    }

    public void m_6199_(Container container) {
        super.m_6199_(container);
        ArcaneTabletMenu.slotChangedCraftingGrid(this, this.player.m_183503_(), this.player, this.craftMatrix, this.craftResult);
    }

    public void m_150399_(int slotId, int button, ClickType clickType, Player player) {
        Slot slot;
        if (slotId >= this.playerSlotsStart && slotId < this.f_38839_.size() && (slot = (Slot)this.f_38839_.get(slotId)).getSlotIndex() == player.m_150109_().f_35977_) {
            return;
        }
        super.m_150399_(slotId, button, clickType, player);
    }

    @Override
    public ItemStack m_7648_(Player player, int index) {
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.getSlotIndex() == player.m_150109_().f_35977_) {
            return ItemStack.f_41583_;
        }
        if (slot instanceof ArcaneTabletResultSlot) {
            ArcaneTabletResultSlot resultSlot = (ArcaneTabletResultSlot)slot;
            if (resultSlot.m_6657_()) {
                ItemStack stack = resultSlot.m_7993_();
                ItemStack oldStack = stack.m_41777_();
                if (!this.m_38903_(stack, this.playerSlotsStart, this.playerSlotsStart + 36, true)) {
                    return ItemStack.f_41583_;
                }
                if (stack.m_41619_()) {
                    resultSlot.m_5852_(ItemStack.f_41583_);
                } else {
                    resultSlot.m_6654_();
                }
                if (stack.m_41613_() == oldStack.m_41613_()) {
                    return ItemStack.f_41583_;
                }
                resultSlot.onTakeNoRefill(player, stack);
                player.m_36176_(stack, false);
                return oldStack;
            }
            return ItemStack.f_41583_;
        }
        return super.m_7648_(player, index);
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot.f_40218_ != this.craftResult && super.m_5882_(stack, slot);
    }

    public void onRecipeTransfer(Int2ObjectMap<List<ItemStack>> stacksMap, boolean transferAll) {
        this.clearCraftingMatrix();
        int repeat = transferAll ? 64 : 1;
        for (int i = 0; i < repeat; ++i) {
            this.transferItems(stacksMap);
        }
        ArcaneTabletMenu.slotChangedCraftingGrid(this, this.player.f_19853_, this.player, this.craftMatrix, this.craftResult);
        this.m_38946_();
    }

    private void transferItems(Int2ObjectMap<List<ItemStack>> stacksMap) {
        stacksMap.forEach(this::transferFromInventory);
        boolean syncEMC = false;
        for (Map.Entry entry : stacksMap.int2ObjectEntrySet()) {
            if (!this.transferFromTablet((Integer)entry.getKey(), (List)entry.getValue())) continue;
            syncEMC = true;
        }
        if (syncEMC) {
            this.provider.syncEmc((ServerPlayer)this.player);
        }
    }

    private boolean transferFromTablet(int destSlot, List<ItemStack> candidateStacks) {
        if (candidateStacks.size() > 1) {
            candidateStacks = candidateStacks.stream().sorted(Comparator.comparingLong(o -> ProjectEAPI.getEMCProxy().getValue(o))).toList();
        }
        for (ItemStack stack : candidateStacks) {
            ItemStack fixed = ProjectEAPI.getEMCProxy().getPersistentInfo(ItemInfo.fromStack((ItemStack)stack)).createStack();
            if (!this.provider.hasKnowledge(fixed)) continue;
            long value = ProjectEAPI.getEMCProxy().getValue(fixed);
            BigInteger bigValue = BigInteger.valueOf(value);
            if (value <= 0L || this.provider.getEmc().compareTo(bigValue) <= 0) continue;
            ItemStack slotItem = this.craftMatrix.m_8020_(destSlot);
            if (slotItem.m_41619_()) {
                this.craftMatrix.m_6836_(destSlot, fixed);
            } else {
                if (slotItem.m_41613_() >= slotItem.m_41741_() || slotItem.m_41720_() != fixed.m_41720_() || !Objects.equals(slotItem.m_41720_().getShareTag(slotItem), fixed.m_41720_().getShareTag(fixed))) continue;
                slotItem.m_41769_(1);
            }
            this.provider.setEmc(this.provider.getEmc().subtract(bigValue));
            return true;
        }
        return false;
    }

    private boolean transferFromInventory(int destSlot, List<ItemStack> candidateStacks) {
        for (ItemStack candidate : candidateStacks) {
            ItemStack candidateFixed = ProjectEAPI.getEMCProxy().getPersistentInfo(ItemInfo.fromStack((ItemStack)candidate)).createStack();
            for (int j = 0; j < this.player.m_150109_().m_6643_(); ++j) {
                ItemStack stack = this.player.m_150109_().m_8020_(j);
                ItemStack fixed = ProjectEAPI.getEMCProxy().getPersistentInfo(ItemInfo.fromStack((ItemStack)stack)).createStack();
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)candidateFixed, (ItemStack)fixed)) continue;
                ItemStack slotItem = this.craftMatrix.m_8020_(destSlot);
                if (slotItem.m_41619_()) {
                    this.craftMatrix.m_6836_(destSlot, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                } else {
                    if (slotItem.m_41613_() >= slotItem.m_41741_() || slotItem.m_41720_() != stack.m_41720_() || !Objects.equals(slotItem.m_41720_().getShareTag(slotItem), stack.m_41720_().getShareTag(stack))) continue;
                    slotItem.m_41769_(1);
                }
                stack.m_41774_(1);
                if (stack.m_41619_()) {
                    this.player.m_150109_().m_6836_(j, ItemStack.f_41583_);
                }
                return true;
            }
        }
        return false;
    }

    public void clearCraftingMatrix() {
        boolean syncEmc = false;
        for (int i = 0; i < this.craftMatrix.m_6643_(); ++i) {
            ItemStack stack = this.craftMatrix.m_8016_(i);
            if (stack.m_41619_()) continue;
            long value = ProjectEAPI.getEMCProxy().getValue(stack);
            if (ProjectEConfig.server.difficulty.covalenceLoss.get() >= 1.0 && value > 0L) {
                ItemInfo itemInfo = ItemInfo.fromStack((ItemStack)stack);
                EXUtils.KnowledgeAddResult res = EXUtils.addKnowledge(this.player, this.provider, ProjectEAPI.getEMCProxy().getPersistentInfo(itemInfo).createStack());
                if (res != EXUtils.KnowledgeAddResult.NOT_ADDED) {
                    this.provider.setEmc(this.provider.getEmc().add(BigInteger.valueOf(value * (long)stack.m_41613_())));
                    syncEmc = true;
                    if (res != EXUtils.KnowledgeAddResult.ADDED) continue;
                    this.provider.syncKnowledgeChange((ServerPlayer)this.player, itemInfo, true);
                    continue;
                }
            }
            this.player.m_150109_().m_150076_(stack, true);
        }
        if (syncEmc) {
            this.provider.syncEmc((ServerPlayer)this.player);
        }
        ArcaneTabletMenu.slotChangedCraftingGrid(this, this.player.f_19853_, this.player, this.craftMatrix, this.craftResult);
    }

    public void rotateCraftingMatrix(boolean clockwise) {
        int i;
        ItemStack[] stacks = new ItemStack[ROTATION_SLOTS.length];
        if (clockwise) {
            for (i = 0; i < ROTATION_SLOTS.length; ++i) {
                int j = i - 1;
                if (j < 0) {
                    j = ROTATION_SLOTS.length - 1;
                }
                stacks[i] = this.craftMatrix.m_8020_(ROTATION_SLOTS[j % ROTATION_SLOTS.length]);
            }
        } else {
            for (i = 0; i < ROTATION_SLOTS.length; ++i) {
                stacks[i] = this.craftMatrix.m_8020_(ROTATION_SLOTS[(i + 1) % ROTATION_SLOTS.length]);
            }
        }
        for (i = 0; i < ROTATION_SLOTS.length; ++i) {
            this.craftMatrix.m_6836_(ROTATION_SLOTS[i], stacks[i]);
        }
        ArcaneTabletMenu.slotChangedCraftingGrid(this, this.player.f_19853_, this.player, this.craftMatrix, this.craftResult);
        this.m_38946_();
    }

    public void balanceCraftingMatrix() {
        ArrayListMultimap map = ArrayListMultimap.create();
        HashMultiset itemCount = HashMultiset.create();
        for (int i = 0; i < this.craftMatrix.m_6643_(); ++i) {
            ItemStack stack = this.craftMatrix.m_8020_(i);
            if (stack.m_41619_() || stack.m_41741_() <= 1) continue;
            CompoundTag key = stack.serializeNBT();
            key.m_128473_("Count");
            map.put((Object)key, (Object)stack);
            itemCount.add((Object)key, stack.m_41613_());
        }
        for (CompoundTag key : map.keySet()) {
            List list = map.get((Object)key);
            int totalCount = itemCount.count((Object)key);
            int countPerStack = totalCount / list.size();
            int restCount = totalCount % list.size();
            for (ItemStack stack : list) {
                stack.m_41764_(countPerStack);
            }
            int idx = 0;
            while (restCount > 0) {
                ItemStack stack;
                stack = (ItemStack)list.get(idx);
                if (stack.m_41613_() < stack.m_41741_()) {
                    stack.m_41769_(1);
                    --restCount;
                }
                if (++idx < list.size()) continue;
                idx = 0;
            }
        }
        ArcaneTabletMenu.slotChangedCraftingGrid(this, this.player.f_19853_, this.player, this.craftMatrix, this.craftResult);
        this.m_38946_();
    }

    public void spreadCraftingMatrix() {
        boolean emptyBiggestSlot;
        do {
            ItemStack biggestStack = null;
            int biggestSize = 1;
            for (int i = 0; i < this.craftMatrix.m_6643_(); ++i) {
                ItemStack stack = this.craftMatrix.m_8020_(i);
                if (stack.m_41619_() || stack.m_41613_() <= biggestSize) continue;
                biggestStack = stack;
                biggestSize = stack.m_41613_();
            }
            if (biggestStack == null) {
                return;
            }
            emptyBiggestSlot = false;
            for (int i = 0; i < this.craftMatrix.m_6643_(); ++i) {
                ItemStack stack = this.craftMatrix.m_8020_(i);
                if (!stack.m_41619_()) continue;
                if (biggestStack.m_41613_() > 1) {
                    this.craftMatrix.m_6836_(i, biggestStack.m_41620_(1));
                    continue;
                }
                emptyBiggestSlot = true;
            }
        } while (emptyBiggestSlot);
        this.balanceCraftingMatrix();
    }

    public class ArcaneTabletCraftingContainer
    extends CraftingContainer {
        private final IItemHandlerModifiable items;

        public ArcaneTabletCraftingContainer(ArcaneTabletMenu tablet, int width, int height, IItemHandlerModifiable items) {
            super((AbstractContainerMenu)tablet, width, height);
            this.items = items;
        }

        public boolean m_7983_() {
            for (int i = 0; i < this.items.getSlots(); ++i) {
                if (this.items.getStackInSlot(i).m_41619_()) continue;
                return false;
            }
            return true;
        }

        public ItemStack m_8020_(int index) {
            return index < 0 || index >= this.m_6643_() ? ItemStack.f_41583_ : this.items.getStackInSlot(index);
        }

        public void m_6836_(int slot, ItemStack stack) {
            this.items.setStackInSlot(slot, stack);
            ArcaneTabletMenu.this.m_6199_((Container)this);
        }

        public ItemStack m_8016_(int index) {
            if (index < 0 || index >= this.m_6643_()) {
                return ItemStack.f_41583_;
            }
            ItemStack stack0 = this.items.getStackInSlot(index);
            this.items.setStackInSlot(index, ItemStack.f_41583_);
            return stack0;
        }

        public ItemStack m_7407_(int index, int count) {
            if (index < 0 || index >= this.m_6643_() || count <= 0 || this.items.getStackInSlot(index).m_41619_()) {
                return ItemStack.f_41583_;
            }
            ItemStack stack = this.items.getStackInSlot(index).m_41620_(count);
            if (!stack.m_41619_()) {
                ArcaneTabletMenu.this.m_6199_((Container)this);
            }
            return stack;
        }

        public void m_6211_() {
            for (int i = 0; i < this.items.getSlots(); ++i) {
                this.items.setStackInSlot(i, ItemStack.f_41583_);
            }
        }

        public void m_5809_(StackedContents helper) {
            for (int i = 0; i < this.items.getSlots(); ++i) {
                helper.m_36491_(this.items.getStackInSlot(i));
            }
        }

        public void m_6596_() {
            ArcaneTabletMenu.this.m_6199_((Container)this);
        }
    }

    public class ArcaneTabletResultSlot
    extends ResultSlot {
        public ArcaneTabletResultSlot(Player player, CraftingContainer matrix, Container result, int slot, int x, int y) {
            super(player, matrix, result, slot, x, y);
        }

        protected void m_7169_(ItemStack stack, int amount) {
            super.m_7169_(stack, amount);
        }

        public void m_142406_(Player player, ItemStack stack) {
            int i;
            ItemStack[] prevItems = new ItemStack[ArcaneTabletMenu.this.craftMatrix.m_6643_()];
            for (i = 0; i < prevItems.length; ++i) {
                prevItems[i] = ArcaneTabletMenu.this.craftMatrix.m_8020_(i);
                if (prevItems[i].m_41619_()) continue;
                prevItems[i] = ItemHandlerHelper.copyStackWithSize((ItemStack)prevItems[i], (int)1);
            }
            super.m_142406_(player, stack);
            for (i = 0; i < prevItems.length; ++i) {
                if (prevItems[i].m_41619_() || !ArcaneTabletMenu.this.craftMatrix.m_8020_(i).m_41619_()) continue;
                ArcaneTabletMenu.this.transferFromTablet(i, (List<ItemStack>)ImmutableList.of((Object)prevItems[i]));
            }
        }

        public void onTakeNoRefill(Player player, ItemStack stack) {
            super.m_142406_(player, stack);
        }
    }
}

